/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.indices;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.fluent.collections.ImmutableMap;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;

public class IndexMapping
implements Document<IndexMapping> {
    private final DocNode baseAttributes;
    private final List<Property> properties;

    public IndexMapping(Property ... properties) {
        this.properties = Arrays.asList(properties);
        this.baseAttributes = DocNode.EMPTY;
    }

    public IndexMapping(DocNode baseAttributes, Property ... properties) {
        this.properties = Arrays.asList(properties);
        this.baseAttributes = baseAttributes;
    }

    public Object toBasicObject() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Property property : this.properties) {
            result.put(property.name, property.toBasicObject());
        }
        return this.baseAttributes.with((Document)DocNode.of((String)"properties", result));
    }

    public static class DynamicIndexMapping
    extends IndexMapping {
        public DynamicIndexMapping(Property ... properties) {
            super(DocNode.of((String)"dynamic", (Object)true), properties);
        }
    }

    public static class DisabledIndexProperty
    extends Property {
        public DisabledIndexProperty(String name) {
            super(name, "object", false, false);
        }
    }

    public static class ObjectProperty
    extends Property {
        private final List<Property> properties;

        public ObjectProperty(String name, Property ... properties) {
            super(name, null);
            this.properties = Arrays.asList(properties);
        }

        @Override
        public Object toBasicObject() {
            DocNode baseDocNode = DocNode.wrap((Object)super.toBasicObject());
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            for (Property property : this.properties) {
                result.put(property.name, property.toBasicObject());
            }
            return baseDocNode.with((Document)DocNode.of((String)"properties", result));
        }
    }

    public static class BinaryProperty
    extends Property {
        public BinaryProperty(String name) {
            super(name, "binary");
        }
    }

    public static class KeywordProperty
    extends Property {
        public KeywordProperty(String name) {
            super(name, "keyword");
        }
    }

    public static class Property
    implements Document<Property> {
        private String name;
        private String type;
        private boolean enabled;
        private boolean dynamic;

        Property(String name, String type) {
            this.name = name;
            this.type = type;
            this.enabled = true;
            this.dynamic = false;
        }

        Property(String name, String type, boolean enabled, boolean dynamic) {
            this.name = name;
            this.type = type;
            this.enabled = enabled;
            this.dynamic = dynamic;
        }

        public Object toBasicObject() {
            return ImmutableMap.ofNonNull((Object)"type", (Object)this.type, (Object)"enabled", (Object)(this.enabled ? null : Boolean.FALSE), (Object)"dynamic", (Object)(this.dynamic ? Boolean.TRUE : null));
        }
    }
}

